﻿Module Program

    Sub Main()
        '以下代码所示的是可用对象转储程序处理的各种
        '对象。从所有值类型到集合和匿名类型，
        '对象转储程序均可以正确格式流畅地显示所有对象

        Sample1()
        Sample2()
        Sample3()
        Sample4()
        Sample5()
        Sample6()
        Sample7()
    End Sub

    Public Sub Sample1()
        '写入可以为 null 的类型
        Dim i As Integer? = 1
        ObjectDumper.Write(i)
    End Sub

    Public Sub Sample2()
        '写入字符串
        Dim str As String = "This is a sample"
        ObjectDumper.Write(str)
    End Sub

    Public Sub Sample3()
        '写入值类型
        Dim i As Decimal = 9.0
        ObjectDumper.Write(i)
    End Sub

    Public Class C4
        Private mem1 As Short
        Public Property Member1() As Short
            Get
                Return mem1
            End Get
            Set(ByVal value As Short)
                mem1 = value
            End Set
        End Property
    End Class
    Public Sub Sample4()
        '写入类及其成员
        Dim iC4 = New C4()
        ObjectDumper.Write(iC4)
    End Sub

    Public Sub Sample5()
        '写入匿名类型
        Dim iAnon = New With {.name = "This is an anonymous type", .value = "First of its kind"}
        ObjectDumper.Write(iAnon)
    End Sub

    Public Sub Sample6()
        '写入数组
        Dim intArr = New Integer() {1, 2, 3, 4, 5}
        ObjectDumper.Write(intArr)
    End Sub

    Public Structure Country
        Dim name As String
        Dim continent As String
    End Structure
    Public Sub Sample7()
        '写出查询结果
        Dim countries = New Country() { _
            New Country With {.name = "USA", .continent = "North America"}, _
            New Country With {.name = "Pakistan", .continent = "Asia"}, _
            New Country With {.name = "Italy", .continent = "Europe"}, _
            New Country With {.name = "Canada", .continent = "North America"}}
        ObjectDumper.Write(From country In countries Where country.continent = "Asia" Select country.name, country.continent)
    End Sub
End Module
